// Listing 10-12

import java.io.*;
import java.util.Scanner;

public class Listing10_12
{
   public static void main(String[] args) throws IOException
   {
      // Zmienne, w których zapiszemy pola rekordu
      String description;
      double quantity;
      
      // Zmienna, w której zapiszemy nową ilość produktu
      double newQuantity;
      
      // Zmienna, w której zapiszemy szukaną wartość
      String searchValue;
      
      // Flaga wskazująca, czy wartość została odnaleziona
      boolean found = false;
      
      // Tworzymy obiekt Scanner, aby odczytać dane wprowadzone na klawiaturze
      Scanner keyboard = new Scanner(System.in);
      
      // Otwieramy plik coffee.dat
      Scanner coffeeFile = new Scanner(new File("coffee.dat"));
      
      // Otwieramy plik tymczasowy, do którego skopiujemy plik pierwotny
      PrintWriter tempFile = new PrintWriter(new File("temp.dat"));
      
      // Pobieramy szukaną wartość
      System.out.print("Wprowadź nazwę kawy, której ilość chcesz zmodyfikować.");
      searchValue = keyboard.nextLine();
      
      // Pobieramy nową ilość produktu
      System.out.print("Wprowadź nową ilość.");
      newQuantity = keyboard.nextDouble();
      
      while (coffeeFile.hasNext())
      {
         // Odczytujemy rekord z pliku;
         // na początku odczytujemy nazwę kawy
         description = coffeeFile.nextLine();
         
         // Następnie odczytujemy ilość
         quantity = coffeeFile.nextDouble();
         // Odczytujemy znak końca linii...
         coffeeFile.nextLine();
         
         // Gdy rekord zawiera szukaną wartość, zapisujemy w pliku tymczasowym nowy rekord
         // W przeciwnym razie w pliku tymczasowym zapisujemy
         // odczytany rekord
         if (description.equalsIgnoreCase(searchValue))
         {
            tempFile.println(description);
            tempFile.println(newQuantity);
            found = true;
         }
         else
         {
            tempFile.println(description);
            tempFile.println(quantity);
         }
      }

      // Zamykamy plik pierwotny
      coffeeFile.close();
      
      // Zamykamy plik tymczasowy
      tempFile.close();
      
      // Otwieramy plik pierwotny do zapisu,
      // usuwając tym samym jego zawartość
      PrintWriter coffeeFile2 = new PrintWriter("coffee.dat");
      
      // Otwieramy plik tymczasowy do odczytu
      Scanner tempFile2 = new Scanner(new File("temp.dat"));
      
      // Kopiujemy po kolei każdy rekord z pliku tymczasowego
      // do pliku pierwotnego
      while(tempFile2.hasNext())
      {
         // Odczytujemy rekord z pliku tymczasowego
         description = tempFile2.nextLine();
         quantity = tempFile2.nextDouble();
         tempFile2.nextLine();
         
         // Zapisujemy rekord w pliku pierwotnym
         coffeeFile2.println(description);
         coffeeFile2.println(quantity);
      }
      
      // Zamykamy plik pierwotny
      coffeeFile2.close();
      
      // Zamykamy plik tymczasowy
      tempFile2.close();      

      // Wyświetlamy informację, czy operacja się powiodła
      if (!found)
         System.out.println(searchValue + ": nie ma takiej kawy w pliku.");
   }
}